// Copyright 1992 by Jon Dart.  All Rights Reserved.

#ifndef _HASH_H
#define _HASH_H

#include "hashable.h"
#include "pinfo.h"

class Hash
{
   public:       

   Hash(const unsigned size, const unsigned long max_entries);
   
   ~Hash();

   Hashable * search( const Hashable &c );
   // searches hash table for an entry matching c

   BOOL insert(Hashable *p, BOOL checkPresent);
   // insert a new entry in the hash table.
           
   void clear(BOOL final = FALSE);      
   // clear the hash table.  Doesn't free its contents (nodes).
	   
   unsigned long num_entries() const;

   unsigned get_size() const
   {
       return my_size;
   }

   unsigned long get_max_entries() const
   {
       return my_max_entries;
   }
           
   private:        
        
   unsigned my_size;
   unsigned long my_max_entries;
   CPtrList **ht;
   unsigned long hash_entries;
};

#endif
